<?php
require_once __DIR__ . '/../includes/auth.php';
require_role(['admin']);
require_once __DIR__ . '/../includes/db.php';

$total = $pdo->query("SELECT COUNT(*) FROM customers")->fetchColumn();
$statusCounts = $pdo->query("SELECT status, COUNT(*) c FROM customers GROUP BY status")->fetchAll();
$perPackage = $pdo->query("SELECT p.name, COUNT(c.id) c FROM packages p LEFT JOIN customers c ON c.package_id=p.id GROUP BY p.id")->fetchAll();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8"><title>Admin Dashboard</title>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<h1>Admin Dashboard</h1>
<p>Total pelanggan: <?= $total ?></p>
<ul>
  <?php foreach($statusCounts as $s) echo "<li>{$s['status']}: {$s['c']}</li>"; ?>
</ul>
<canvas id="chartPaket" width="400" height="200"></canvas>
<script>
const ctx = document.getElementById('chartPaket').getContext('2d');
new Chart(ctx, {
  type: 'bar',
  data: {
    labels: <?= json_encode(array_column($perPackage,'name')) ?>,
    datasets: [{
      label: 'Jumlah pelanggan per paket',
      data: <?= json_encode(array_column($perPackage,'c')) ?>,
    }]
  }
});
</script>
<p><a href="packages.php">Manage Packages</a> | <a href="customers.php">Customers</a> | <a href="/logout.php">Logout</a></p>
</body></html>
